

PROCEDURE SETPARTBACKTRACK(
        M,N,INF   :INTEGER;
   VAR SETS       :SETFAMILY;
   VAR SETLISTS   :INDEXSET;
   VAR C          :ARRN;
   VAR NONFEASIBLE:BOOLEAN;
   VAR COST,COUNT :INTEGER;
   VAR COVER      :ARRN);

   VAR CURRENTCOST,G,H,I,J,JK,K,L,MCOV,MIN,N1,OPTK:INTEGER;
       CC,MINR                                    :REAL;
       B,MOVE,TOTALBC                             :BOOLEAN;
       P                                          :POINTEL;
       BLOCKSIZE,ELCOV,MINCBLOCK                  :ARRM;
       BLOCK                                      :ARRM1;
       BCBOOL                                     :ARRMB;
       COV,COV1,OPTCOV                            :ARRN;
       ORDER,INVORD                               :ARRN1;
       RATIO                                      :ARRNR;
       MINRATIO                                   :ARRN1R;
       BLOCKCOVER                                 :ARRMM;

   PROCEDURE SAVESOLUTION;
      { THIS PROCEDURE SAVES A CURRENT SOLUTIION AS THE BEST
        CURRENT SOLUTION. }
      VAR H:INTEGER;
   BEGIN
      NONFEASIBLE:=FALSE;  COST:=CURRENTCOST;
      FOR H:=1 TO K DO OPTCOV[H]:=COV[H];
      OPTK:=K
   END;  { SAVE SOLUTION }

   FUNCTION FEASIBLE(I:INTEGER):BOOLEAN;
      { FEASIBLE IS TRUE IF CURRENTLY UNCOVERED ELEMENTS CAN BE
        COVERED BY SOME UNUSED SETS IN BLOCKS I, I+1, ..., M AND
        FALSE OTHERWISE. }
      VAR G:INTEGER;
          B:BOOLEAN;
   BEGIN
      IF TOTALBC OR BCBOOL[I] THEN FEASIBLE:=TRUE
      ELSE BEGIN
         G:=I;
         REPEAT
            B:=(ELCOV[G] = 0) AND (BLOCKCOVER[G,I] = 0);
            G:=G+1
         UNTIL  B OR (G > M);
         FEASIBLE:=NOT B
      END  { ELSE TOTALBC OR ... }
   END;  { FEASIBLE }

   FUNCTION FIT(J:INTEGER):BOOLEAN;
      { FIT IS TRUE IF SET J DOES NOT OVERCOVER ELEMENTS COVERED
        BY A CURRENT PARTIAL SOLUTION, AND FALSE OTHERWISE. }
      VAR B:BOOLEAN;
          P:POINTEL;
   BEGIN
      IF SETS[J].CARD > MCOV THEN FIT:=FALSE
      ELSE BEGIN
         B:=TRUE;  P:=SETS[J].LIST;
         WHILE (P <> NIL) AND B DO BEGIN
            B:=ELCOV[P^.ELEM] = 0;
            P:=P^.NEXT
         END;
         FIT:=B
      END  { ELSE SETS[J].CARD > MCOV }
   END;  { FIT }

   PROCEDURE BACKWARDMOVE(VAR MOVE:BOOLEAN);
      { PROCEDURE MOVES THE SEARCH TO THE FIRST FROM THE END BLOCK
        WHICH STILL CONTAINS SOME UNUSED SETS. VARIABLE MOVE BECOMES
        TRUE IF SUCH A BLOCK EXISTS AND FALSE OTHERWISE. }
      VAR P:POINTEL;
   BEGIN
      IF K = 0 THEN MOVE:=FALSE
      ELSE BEGIN
         REPEAT  { UNTIL (K = 0) OR MOVE }
            J:=COV[K];  I:=COV1[K];
            K:=K-1;
            P:=SETS[J].LIST;
            WHILE P <> NIL DO BEGIN
               ELCOV[P^.ELEM]:=0;
               P:=P^.NEXT
            END;
            CURRENTCOST:=CURRENTCOST-C[J];
            MCOV:=MCOV+SETS[J].CARD;
            MOVE:=INVORD[J] < BLOCK[I+1]-1
         UNTIL (K = 0) OR MOVE;
         IF MOVE THEN BEGIN
            JK:=INVORD[J]+1;  J:=ORDER[JK]
         END
      END  { ELSE: K <> 0 }
   END;  { BACKWARD MOVE }

   PROCEDURE FORWARDMOVE;
      { PROCEDURE ADDS SET J TO A CURRENT PARTIAL COVER. IF ALL
        ELEMENTS ARE COVERED, PROCEDURE SAVESOLUTION UPDATES
        THE BEST CURRENT SOLUTION AND BACKWARDMOVE IS CALLED.
        OTHERWISE, SEARCH FOR A FEASIBLE SET IS CONTINUED. }
      VAR P:POINTEL;
   BEGIN
      COUNT:=COUNT+1;  K:=K+1;
      COV[K]:=J;  COV1[K]:=I;
      P:=SETS[J].LIST;
      WHILE P <> NIL DO BEGIN
         ELCOV[P^.ELEM]:=1;  P:=P^.NEXT
      END;
      CURRENTCOST:=CURRENTCOST+C[J];
      MCOV:=MCOV-SETS[J].CARD;
      IF MCOV = 0 THEN BEGIN             { ALL ELEMENTS ARE COVERED }
         SAVESOLUTION;       { A NEW BETTER SOLUTION HAS BEEN FOUND }
         BACKWARDMOVE(MOVE)
      END  { IF MCOV = 0 }
      ELSE BEGIN
         WHILE ELCOV[I] = 1 DO I:=I+1;
         IF NOT FEASIBLE(I) THEN BACKWARDMOVE(MOVE)
         ELSE BEGIN
            JK:=BLOCK[I];  J:=ORDER[JK];
            IF (CURRENTCOST+MINCBLOCK[I] >= COST) OR
               (TRUNC(CURRENTCOST+MCOV*MINRATIO[JK]) >= COST) THEN
               BACKWARDMOVE(MOVE)
            ELSE MOVE:=TRUE
         END;  { ELSE: FEASIBLE(I) }
      END  { ELSE: MCOV <> 0 }
   END;  { FORWARD MOVE }

BEGIN                                                   { MAIN BODY }
   N1:=N+1;                                         { ORDERING SETS }
   FOR I:=1 TO M DO BLOCKSIZE[I]:=0;
   FOR J:=1 TO N DO BEGIN
      RATIO[J]:=C[J]/SETS[J].CARD;
      L:=SETS[J].LIST^.ELEM;
      BLOCKSIZE[L]:=BLOCKSIZE[L]+1
   END;  { FOR J }
   L:=1;
   FOR I:=1 TO M DO BEGIN
      BLOCK[I]:=L;  L:=L+BLOCKSIZE[I]
   END;
   BLOCK[M+1]:=L;
   FOR I:=1 TO M DO ELCOV[I]:=BLOCK[I];
   FOR J:=1 TO N DO BEGIN
      L:=SETS[J].LIST^.ELEM;  K:=ELCOV[L];
      ORDER[K]:=J;  ELCOV[L]:=K+1
   END;
   ORDER[N1]:=N1;  INVORD[N1]:=N1;
   J:=1;  I:=1;
   WHILE J < N DO BEGIN
      K:=BLOCKSIZE[I];
      IF K > 1 THEN HEAPSORT(K,J,RATIO,ORDER);
      I:=I+1;  J:=BLOCK[I]
   END;  { WHILE J < N }
   FOR J:=1 TO N DO INVORD[ORDER[J]]:=J;
   FOR I:=1 TO M DO BEGIN { AUXILIARY VARIABLES FOR DOMINANCE TESTS }
      MIN:=INF;
      FOR J:=BLOCK[I] TO BLOCK[I+1]-1 DO BEGIN
         K:=C[ORDER[J]];
         IF K < MIN THEN MIN:=K
      END;
      MINCBLOCK[I]:=MIN
   END;  { FOR I }
   MINR:=INF;  MINRATIO[N1]:=MINR;
   FOR J:=N DOWNTO 1 DO BEGIN
      CC:=RATIO[ORDER[J]];
      IF CC < MINR THEN MINR:=CC;
      MINRATIO[J]:=MINR
   END;  { FOR J }
   TOTALBC:=BLOCK[M] <= N;                { AUXILIARY VARIABLES FOR }
   BCBOOL[M]:=TOTALBC;                          { FEASIBILITY TESTS }
   IF TOTALBC THEN BLOCKCOVER[M,M]:=1
   ELSE BLOCKCOVER[M,M]:=0;
   L:=M;  B:=TOTALBC;
   FOR I:=M-1 DOWNTO 1 DO
      IF BLOCKSIZE[I] = 0 THEN BEGIN
         B:=FALSE;  BCBOOL[I]:=FALSE;
         TOTALBC:=FALSE;  BLOCKCOVER[I,I]:=0;
         FOR H:=I+1 TO M DO BLOCKCOVER[H,I]:=BLOCKCOVER[H,L];
         L:=I
      END  { IF BLOCKSIZE[I] = 0 }
      ELSE
         IF B THEN BEGIN
            BCBOOL[I]:=TRUE;  BLOCKCOVER[I,L]:=1
         END
         ELSE BEGIN
            BLOCKCOVER[I,I]:=1;
            K:=1;
            FOR H:=I+1 TO M DO BEGIN
               G:=BLOCKCOVER[H,L];
               BLOCKCOVER[H,I]:=G;
               K:=K+G
            END;  { FOR H }
            N1:=M-I+1;  J:=BLOCK[I];
            WHILE (J < BLOCK[I+1]) AND (K < N1) DO BEGIN
               H:=ORDER[J];
               P:=SETS[H].LIST^.NEXT;
               WHILE (P <> NIL) AND (K < N1) DO BEGIN
                  G:=P^.ELEM;
                  IF BLOCKCOVER[G,I] = 0 THEN BEGIN
                     BLOCKCOVER[G,I]:=1; K:=K+1
                  END;
                  P:=P^.NEXT
               END;  { WHILE (P <> NIL) ... }
               J:=J+1
            END;  { WHILE (J < BLOCK[I+1]) ... }
            B:=K = N1;  BCBOOL[I]:=B;  L:=I
         END;  { ELSE: NOT B, FOR I }       { END OF INITIALIZATION }
   COUNT:=0;  NONFEASIBLE:=TRUE;
   FOR L:=1 TO M DO ELCOV[L]:=0;
   IF FEASIBLE(1) THEN BEGIN
      I:=1;  K:=0;  JK:=1;
      J:=ORDER[1];
      COST:=INF;  CURRENTCOST:=0;
      MCOV:=M;               { MCOV  - NUMBER OF UNCOVERED ELEMENTS }
      FORWARDMOVE;
      WHILE MOVE DO BEGIN    { MOVE=TRUE IF SEARCH IS NOT EXHAUSTED }
         REPEAT  { UNTIL B OR NOT MOVE }      { AND FALSE OTHERWISE }
            REPEAT
               B:=FALSE;
               WHILE (JK < BLOCK[I+1]) AND (NOT B ) DO BEGIN
                  B:=(CURRENTCOST+C[J] < COST) AND FIT(J);
                  IF NOT B THEN BEGIN
                     JK:=JK+1;  J:=ORDER[JK]
                  END
               END;  { WHILE (JK < BLOCK[I+1]) ... }
               IF JK = BLOCK[I+1] THEN BACKWARDMOVE(MOVE)
            UNTIL B OR NOT MOVE;
            IF B THEN
               B:=CURRENTCOST+C[J]+(MCOV-SETS[J].CARD)
                  *MINRATIO[JK+1] < COST;
            IF MOVE AND NOT B THEN BEGIN
               JK:=JK+1;  J:=ORDER[JK]
            END
         UNTIL B OR NOT MOVE;
         IF B THEN FORWARDMOVE
      END;  { WHILE MOVE }
      IF NOT NONFEASIBLE THEN BEGIN
         FOR J:=1 TO N DO COVER[J]:=0;
         FOR J:=1 TO OPTK DO COVER[OPTCOV[J]]:=1
      END
   END  { IF FEASIBLE(1) }
END;  { SETPARTBACKTRACK }





